\name{homology#HOMODATA#}
\alias{homology#HOMODATA#}
\title{Annotation of #ORGANISM# HomologGeneIDs by homology data of other
  organisms that have hology relationships with #ORGANISM#}
\description{
  homology#HOMODATA# is an environment (hash table) object containing
  key and value pairs for the mappings between #ORGANISM# internal
  HomologGeneIDs (keys) representing a sequence and the data for the
  best matching sequences in other organisms represented by a list of
  homoData object(s).  
}
\details{
  Keys of homology#HOMODATA# are the HomologGeneIDs used by NCBI to
  represent a #ORGANISM# sequence and values are list of homoData
  objects for other organisms that have been identified to have homology
  relationships with #ORGANISM#. The list for a given #ORGANISM#
  internal HomologGeneID may have one to many homoData objects depending
  on whether homolgy relationships have been identified in only one or more
  other organisms.

  A homoData object has slots for the name of the organism (homoOrg),
  LocusLink id (homoLL), internal HomologGeneId (homoHGID), and GenBank
  accession number (homoACC) of the best matching sequence, type of similarity
  (homoType. B - reciprocal best best between three or more organisms, b
  - reciprocal best match between two organisms, and c - curated
  homology relationship between two organisms), percent of identity
  (homoPS) of the alignment between the matching sequences, and a url
  (homoURL) to the source if the relationship is a curated
  orthology. The homoData objects with homoType = B or b will not have any
  value for homoURL and objects with homoType = c will not have any
  value for homoPS. 

  Keys of homology#HOMODATA# can be accessed using ls(homology#HOMODATA#) and
  values using mget(keys, homology#HOMODATA#). The value of a given slot
  of a homoData object can be accessed by using homoOrg(xxx) for the
  homoOrg slot of the homoData object xxx, for example. 

  Mappings contained in homology#HOMODATA# were based on data provided
  by HomoloGene.
  
  Homology source built: HomoloGene built date notavailable.  

  homology#HOMODATA# package built: #BUILT#
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/HomoloGene/hmlg.ftp}
}
\examples{
    require("annotate") || stop("annotate unavailable")
    # Gets all the keys of homology#HOMODATA#
    xx <- ls(env = homology#HOMODATA#)

    if(length(xx) > 0){
	# Gets the homology data for the first key of homology#HOMODATA#
	homodata <- get(xx[1], env = homology#HOMODATA#)

        # Gets the organism name, LocusLink id, internal HomoloGene id,
        # GenBank accession number, type of similarity, percent
        # similarity, and URL for percent similarity for the first
        # homoData object in the list obtained previously
        homoOrg(homodata[[1]])
        homoLL(homodata[[1]])
        homoHGID(homodata[[1]])
        homoACC(homodata[[1]])
        homoType(homodata[[1]])
        homoPS(homodata[[1]])
        homoURL(homodata[[1]])
        # Gets the values for more than one keys
        mget(xx[1:3], env = homology#HOMODATA#)
    }
}
\keyword{datasets}

